/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredDecoration;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredMarker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.WaystonesCompat;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2185;
import net.minecraft.class_22;
import net.minecraft.class_2215;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2546;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2587;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

public class ModMapMarkers {
    public static final HolderReference<MLMapDecorationType<?, ?>> DEATH_MARKER = HolderReference.of((class_2960)Supplementaries.res("death_marker"), (class_5321)MapDataRegistry.MAP_DECORATION_REGISTRY_KEY);
    public static final class_2960 WAY_SIGN_FACTORY_ID = Supplementaries.res("way_sign");
    public static final class_2960 WAYSTONE_FACTORY_ID = Supplementaries.res("waystone");
    public static final class_2960 BANNER_FACTORY_ID = Supplementaries.res("banner");
    public static final class_2960 BED_FACTORY_ID = Supplementaries.res("bed");
    public static final class_2960 FLAG_FACTORY_ID = Supplementaries.res("flag");

    public static void init() {
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((class_2960)WAY_SIGN_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldSimple(ModMapMarkers::signPost));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((class_2960)WAYSTONE_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldSimple(ModMapMarkers::waystone));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((class_2960)BANNER_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::banner));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((class_2960)BED_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::bed));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((class_2960)FLAG_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::flag));
        MapDataRegistry.addDynamicServerMarkersEvent(ModMapMarkers::getForPlayer);
    }

    public static Set<MLMapMarker<?>> getForPlayer(class_1657 player, class_9209 mapId, class_22 data) {
        Optional v = player.method_43122();
        if (v.isPresent() && data.field_118.equals(((class_4208)v.get()).comp_2207()) && CommonConfigs.Tweaks.DEATH_MARKER.get().isOn(player)) {
            SimpleMapMarker marker = new SimpleMapMarker(DEATH_MARKER.getHolder((class_1297)player), ((class_4208)v.get()).comp_2208(), Float.valueOf(0.0f), Optional.of(class_2561.method_43471((String)"message.supplementaries.death_marker")));
            return Set.of(marker);
        }
        return Set.of();
    }

    @Nullable
    private static SimpleMapMarker signPost(class_6880<MLMapDecorationType<?, ?>> type, class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)class_25862;
            class_5250 t = class_2561.method_43470((String)"");
            if (tile.getSignUp().active()) {
                t = tile.getTextHolder(0).getMessage(0, false);
            }
            if (tile.getSignDown().active() && t.getString().isEmpty()) {
                t = tile.getTextHolder(1).getMessage(0, false);
            }
            if (t.getString().isEmpty()) {
                t = null;
            }
            return new SimpleMapMarker(type, pos, Float.valueOf(0.0f), Optional.ofNullable(t));
        }
        return null;
    }

    @Nullable
    private static ColoredMarker bed(class_6880<MLMapDecorationType<?, ?>> type, class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_2587) {
            class_2587 tile = (class_2587)class_25862;
            class_1767 dyecolor = tile.method_11018();
            return new ColoredMarker(type, pos, dyecolor);
        }
        return null;
    }

    @Nullable
    private static ColoredMarker flag(class_6880<MLMapDecorationType<?, ?>> type, class_1922 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)class_25862;
            class_1767 dyecolor = tile.getColor();
            class_2561 name = tile.method_16914() ? tile.method_5797() : null;
            return new ColoredMarker(type, pos, name, dyecolor);
        }
        return null;
    }

    @Nullable
    private static ColoredMarker banner(class_6880<MLMapDecorationType<?, ?>> type, class_1922 world, class_2338 pos) {
        class_1767 col;
        class_2248 block = world.method_8320(pos).method_26204();
        if (block instanceof class_2185 && !(block instanceof class_2546) && !(block instanceof class_2215) && (col = BlocksColorAPI.getColor((class_2248)block)) != null) {
            class_1275 n;
            class_2586 be = world.method_8321(pos);
            class_2561 name = be instanceof class_1275 && (n = (class_1275)be).method_16914() ? n.method_5797() : null;
            return new ColoredMarker(type, pos, name, col);
        }
        return null;
    }

    @Nullable
    private static SimpleMapMarker waystone(class_6880<MLMapDecorationType<?, ?>> type, class_1922 world, class_2338 pos) {
        class_2586 te;
        if (CompatHandler.WAYSTONES && WaystonesCompat.isWaystone(te = world.method_8321(pos))) {
            class_2561 name = WaystonesCompat.getName(te);
            return new SimpleMapMarker(type, pos, Float.valueOf(0.0f), Optional.of(name));
        }
        return null;
    }
}

